# WiFiBoy Gyro example (BlitEngine/WiFiBoyMini)
# 2018.10.24, tklua@wifiboy.org

from machine import I2C, Pin
from mpu9250 import MPU9250
i2c = I2C(scl=Pin(22), sda=Pin(23))
sensor = MPU9250(i2c)

x = y = 64
color = wb.WHITE
wb.cls()
while True:
    x+=sensor.acceleration[0]/5
    if x<0: x=0
    if x>127: x=127
    y+=sensor.acceleration[1]/5
    if y<0: y=0 
    if y>127: y=127
    if wb.getkey()&1: wb.cls()
    elif wb.getkey()&2: 
        while wb.getkey()&2: pass
    elif wb.getkey()&4: color=wb.RED
    elif wb.getkey()&8: color=wb.GREEN
    elif wb.getkey()&16: color=wb.YELLOW
    elif wb.getkey()&32: color=wb.BLUE
    wb.pix(int(x),int(y),color)
